/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class StaticTokenScanner
implements ScannerDelegate {
    private final Pattern patterns;

    public StaticTokenScanner(String ... values) {
        StringBuilder builder = new StringBuilder();
        builder.append("^(");
        builder.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            builder.append('|');
            builder.append(values[i]);
        }
        builder.append(')');
        this.patterns = Pattern.compile(builder.toString());
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(this.patterns);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(this.patterns)) {
            return reader.accept(kind);
        }
        throw ScannerUtil.unexpectedInput(reader, kind);
    }
}

