/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import org.sterling.SterlingException;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class TerminatorScanner
implements ScannerDelegate {
    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        this.skipWhitespace(reader);
        boolean expected = reader.expect('\n') || reader.expect(';');
        reader.reject();
        return expected;
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (this.expect(kind, reader)) {
            this.skipWhitespace(reader);
            reader.store();
            return reader.accept(kind);
        }
        throw ScannerUtil.unexpectedInput(reader, kind);
    }

    private void skipWhitespace(InputReader reader) {
        while (Character.isWhitespace(reader.peek()) && !reader.expect('\n')) {
            reader.skip();
        }
    }
}

