/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sterling.source.translator.Alias;

public class AliasBuilder {
    private final List<String> from = new ArrayList<String>();
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public void addImport(String importName) {
        this.imports.add(importName);
        this.setAlias(importName);
    }

    public void appendFrom(String modulePart) {
        this.from.add(modulePart);
    }

    public List<Alias> acceptImports() {
        String module = this.acceptModule();
        List<Alias> accepted = this.acceptImports(module);
        this.reset();
        return accepted;
    }

    public void setAlias(String alias) {
        this.aliases.put(this.imports.get(this.imports.size() - 1), alias);
    }

    private List<Alias> acceptImports(String module) {
        ArrayList<Alias> imports = new ArrayList<Alias>();
        for (String importName : this.imports) {
            imports.add(new Alias(module + '/' + importName, this.aliases.get(importName)));
        }
        return imports;
    }

    private String acceptModule() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator = this.from.iterator();
        builder.append(iterator.next());
        while (iterator.hasNext()) {
            builder.append('/');
            builder.append(iterator.next());
        }
        this.from.clear();
        return builder.toString();
    }

    private void reset() {
        this.from.clear();
        this.imports.clear();
    }
}

