/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.translator;

import java.util.Set;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.AccessedExpression;
import org.sterling.runtime.expression.AppliedExpression;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.Repository;
import org.sterling.runtime.expression.Variable;
import org.sterling.source.syntax.AccessorExpression;
import org.sterling.source.syntax.ApplyExpression;
import org.sterling.source.syntax.ArgumentExpression;
import org.sterling.source.syntax.ArgumentsExpression;
import org.sterling.source.syntax.ArgumentsExpressionTail;
import org.sterling.source.syntax.BinaryExpression;
import org.sterling.source.syntax.BinaryExpressionTail;
import org.sterling.source.syntax.BooleanLiteral;
import org.sterling.source.syntax.BooleanToken;
import org.sterling.source.syntax.CharacterLiteral;
import org.sterling.source.syntax.CharacterToken;
import org.sterling.source.syntax.ConstantExpression;
import org.sterling.source.syntax.Declaration;
import org.sterling.source.syntax.DeclarationLiteral;
import org.sterling.source.syntax.DeclarationSequence;
import org.sterling.source.syntax.DeclarationSequenceTail;
import org.sterling.source.syntax.DoubleLiteral;
import org.sterling.source.syntax.DoubleToken;
import org.sterling.source.syntax.FromIdentifier;
import org.sterling.source.syntax.FromIdentifierList;
import org.sterling.source.syntax.FromIdentifierListTail;
import org.sterling.source.syntax.FromIdentifierTail;
import org.sterling.source.syntax.FromIdentifiers;
import org.sterling.source.syntax.FromStatement;
import org.sterling.source.syntax.FunctionArguments;
import org.sterling.source.syntax.FunctionArgumentsTail;
import org.sterling.source.syntax.FunctionLiteral;
import org.sterling.source.syntax.ImportHeader;
import org.sterling.source.syntax.ImportHeaderSuffix;
import org.sterling.source.syntax.ImportHeaderTail;
import org.sterling.source.syntax.ImportHeaders;
import org.sterling.source.syntax.ImportIdentifier;
import org.sterling.source.syntax.ImportIdentifierAlias;
import org.sterling.source.syntax.ImportIdentifierTail;
import org.sterling.source.syntax.ImportStatement;
import org.sterling.source.syntax.IndexerArgument;
import org.sterling.source.syntax.IndexerArguments;
import org.sterling.source.syntax.IndexerArgumentsSuffix;
import org.sterling.source.syntax.IndexerArgumentsTail;
import org.sterling.source.syntax.IndexerExpression;
import org.sterling.source.syntax.IntegerLiteral;
import org.sterling.source.syntax.IntegerToken;
import org.sterling.source.syntax.LambdaArgument;
import org.sterling.source.syntax.LambdaLiteral;
import org.sterling.source.syntax.LiteralExpression;
import org.sterling.source.syntax.ModuleDeclaration;
import org.sterling.source.syntax.ModuleHeader;
import org.sterling.source.syntax.ModuleIdentifier;
import org.sterling.source.syntax.ModuleIdentifierTail;
import org.sterling.source.syntax.NullLiteral;
import org.sterling.source.syntax.ObjectArgument;
import org.sterling.source.syntax.ObjectArguments;
import org.sterling.source.syntax.ObjectArgumentsList;
import org.sterling.source.syntax.ObjectBody;
import org.sterling.source.syntax.ObjectHeader;
import org.sterling.source.syntax.ObjectLiteral;
import org.sterling.source.syntax.ObjectMember;
import org.sterling.source.syntax.ObjectMemberName;
import org.sterling.source.syntax.ObjectMembers;
import org.sterling.source.syntax.ObjectMembersSuffix;
import org.sterling.source.syntax.ObjectMembersTail;
import org.sterling.source.syntax.ParentheticalExpression;
import org.sterling.source.syntax.PrimaryExpression;
import org.sterling.source.syntax.QualifiedIdentifier;
import org.sterling.source.syntax.QualifiedIdentifierTail;
import org.sterling.source.syntax.SelectorExpression;
import org.sterling.source.syntax.SelectorExpressionTail;
import org.sterling.source.syntax.SingleObjectArgument;
import org.sterling.source.syntax.SourceExpression;
import org.sterling.source.syntax.SourceNode;
import org.sterling.source.syntax.SourceVisitor;
import org.sterling.source.syntax.StringLiteral;
import org.sterling.source.syntax.StringToken;
import org.sterling.source.syntax.TernaryExpression;
import org.sterling.source.syntax.TernaryExpressionTail;
import org.sterling.source.syntax.UnaryExpression;
import org.sterling.source.translator.TranslatorState;

public class Translator
implements SourceVisitor<Expression, TranslatorState> {
    public Set<DeclaredExpression> translate(SourceNode tree, Repository repository) throws SterlingException {
        TranslatorState state = new TranslatorState(repository);
        this.visit(tree, state);
        return state.getDeclarations();
    }

    @Override
    public Expression visit(SourceNode node, TranslatorState state) throws SterlingException {
        return node.accept(this, state);
    }

    @Override
    public Expression visitAccessorExpression(AccessorExpression accessor, TranslatorState state) throws SterlingException {
        return ExpressionFactory.access(state.popExpression(), ExpressionFactory.symbol(accessor.getIdentifier().getValue()));
    }

    @Override
    public Expression visitApplyExpression(ApplyExpression expression, TranslatorState state) throws SterlingException {
        return this.visit(expression.getOperand(), state);
    }

    @Override
    public Expression visitArgument(ArgumentExpression argument, TranslatorState state) throws SterlingException {
        return ExpressionFactory.apply(state.popExpression(), this.visit(argument.getExpression(), state));
    }

    @Override
    public Expression visitArgumentsExpression(ArgumentsExpression arguments, TranslatorState state) throws SterlingException {
        return this.join(arguments.getArgument(), arguments.getTail(), state);
    }

    @Override
    public Expression visitArgumentsExpressionTail(ArgumentsExpressionTail tail, TranslatorState state) throws SterlingException {
        return this.join(tail.getArgument(), tail.getTail(), state);
    }

    @Override
    public Expression visitBinaryExpression(BinaryExpression binary, TranslatorState state) throws SterlingException {
        return this.join(binary.getOperand(), binary.getTail(), state);
    }

    @Override
    public Expression visitBinaryExpressionTail(BinaryExpressionTail tail, TranslatorState state) throws SterlingException {
        AccessedExpression expression = ExpressionFactory.access(state.popExpression(), ExpressionFactory.symbol(tail.getOperator().getValue()));
        AppliedExpression application = ExpressionFactory.apply(expression, this.visit(tail.getOperand(), state));
        return this.join(application, tail.getTail(), state);
    }

    @Override
    public Expression visitBooleanLiteral(BooleanLiteral literal, TranslatorState state) throws SterlingException {
        return ExpressionFactory.constant(((BooleanToken)literal.getLiteral()).isTrue());
    }

    @Override
    public Expression visitCharacterLiteral(CharacterLiteral literal, TranslatorState state) throws SterlingException {
        return ExpressionFactory.constant(((CharacterToken)literal.getLiteral()).getCharValue());
    }

    @Override
    public Expression visitConstantExpression(ConstantExpression lambda, TranslatorState state) throws SterlingException {
        return this.visit(lambda.getBody(), state);
    }

    @Override
    public Expression visitDeclaration(Declaration lambda, TranslatorState state) throws SterlingException {
        state.declare(lambda.getIdentifier(), this.visit(lambda.getTail(), state));
        return null;
    }

    @Override
    public Expression visitDeclarationLiteral(DeclarationLiteral tail, TranslatorState state) throws SterlingException {
        return this.visit(tail.getLambda(), state);
    }

    @Override
    public Expression visitDeclarationSequence(DeclarationSequence sequence, TranslatorState state) throws SterlingException {
        this.visit(sequence.getDeclaration(), state);
        this.visit(sequence.getTail(), state);
        return null;
    }

    @Override
    public Expression visitDeclarationSequenceTail(DeclarationSequenceTail tail, TranslatorState state) throws SterlingException {
        this.visit(tail.getSequence(), state);
        return null;
    }

    @Override
    public Expression visitDoubleLiteral(DoubleLiteral literal, TranslatorState state) throws SterlingException {
        return ExpressionFactory.constant(((DoubleToken)literal.getLiteral()).getDoubleValue());
    }

    @Override
    public Expression visitExpression(SourceExpression expression, TranslatorState state) throws SterlingException {
        return this.visit(expression.getOperand(), state);
    }

    @Override
    public Expression visitFromIdentifier(FromIdentifier identifier, TranslatorState state) throws SterlingException {
        state.appendFrom(identifier.getValue());
        this.visit(identifier.getTail(), state);
        return null;
    }

    @Override
    public Expression visitFromIdentifierAlias(ImportIdentifierAlias alias, TranslatorState state) throws SterlingException {
        state.setAlias(alias.getValue());
        return null;
    }

    @Override
    public Expression visitFromIdentifierList(FromIdentifierList list, TranslatorState state) throws SterlingException {
        state.addImport(list.getValue());
        this.visit(list.getAlias(), state);
        this.visit(list.getTail(), state);
        return null;
    }

    @Override
    public Expression visitFromIdentifierListTail(FromIdentifierListTail tail, TranslatorState state) throws SterlingException {
        this.visit(tail.getList(), state);
        return null;
    }

    @Override
    public Expression visitFromIdentifierTail(FromIdentifierTail tail, TranslatorState state) throws SterlingException {
        state.appendFrom(tail.getValue());
        this.visit(tail.getTail(), state);
        return null;
    }

    @Override
    public Expression visitFromIdentifiers(FromIdentifiers identifiers, TranslatorState state) throws SterlingException {
        this.visit(identifiers.getList(), state);
        return null;
    }

    @Override
    public Expression visitFromStatement(FromStatement from, TranslatorState state) throws SterlingException {
        this.visit(from.getModule(), state);
        this.visit(from.getAliases(), state);
        state.acceptImports();
        return null;
    }

    @Override
    public Expression visitFunctionArguments(FunctionArguments arguments, TranslatorState state) throws SterlingException {
        return ExpressionFactory.lambda(state.define((Variable)this.visit(arguments.getArgument(), state)), this.visitLambdaArguments(arguments.getTail(), state));
    }

    @Override
    public Expression visitFunctionArgumentsTail(FunctionArgumentsTail list, TranslatorState state) throws SterlingException {
        return ExpressionFactory.lambda(state.define((Variable)this.visit(list.getArgument(), state)), this.visitLambdaArguments(list.getTail(), state));
    }

    @Override
    public Expression visitFunctionLiteral(FunctionLiteral lambda, TranslatorState state) throws SterlingException {
        state.pushSource(lambda.getExpression());
        state.enterScope();
        Expression expression = this.visit(lambda.getArguments(), state);
        state.leaveScope();
        return expression;
    }

    @Override
    public Expression visitImportHeader(ImportHeader header, TranslatorState state) throws SterlingException {
        this.visit(header.getStatement(), state);
        this.visit(header.getSuffix(), state);
        return null;
    }

    @Override
    public Expression visitImportHeaderSuffix(ImportHeaderSuffix suffix, TranslatorState state) throws SterlingException {
        this.visit(suffix.getTail(), state);
        return null;
    }

    @Override
    public Expression visitImportHeaderTail(ImportHeaderTail tail, TranslatorState state) throws SterlingException {
        this.visit(tail.getHeader(), state);
        this.visit(tail.getSuffix(), state);
        return null;
    }

    @Override
    public Expression visitImportHeaders(ImportHeaders headers, TranslatorState state) throws SterlingException {
        if (headers.isDeclared()) {
            this.visit(headers.getHeader(), state);
        }
        return null;
    }

    @Override
    public Expression visitImportIdentifier(ImportIdentifier identifier, TranslatorState state) throws SterlingException {
        state.appendFrom(identifier.getValue());
        this.visit(identifier.getTail(), state);
        this.visit(identifier.getAlias(), state);
        state.acceptImports();
        return null;
    }

    @Override
    public Expression visitImportIdentifierTail(ImportIdentifierTail tail, TranslatorState state) throws SterlingException {
        if (tail.hasTail()) {
            state.appendFrom(tail.getValue());
            this.visit(tail.getTail(), state);
        } else {
            state.addImport(tail.getValue());
        }
        return null;
    }

    @Override
    public Expression visitImportStatement(ImportStatement statement, TranslatorState state) throws SterlingException {
        this.visit(statement.getAlias(), state);
        return null;
    }

    @Override
    public Expression visitIndexerArgument(IndexerArgument argument, TranslatorState state) throws SterlingException {
        return ExpressionFactory.apply(state.popExpression(), this.visit(argument.getExpression(), state));
    }

    @Override
    public Expression visitIndexerArguments(IndexerArguments arguments, TranslatorState state) throws SterlingException {
        return this.join(arguments.getArgument(), arguments.getSuffix(), state);
    }

    @Override
    public Expression visitIndexerArgumentsSuffix(IndexerArgumentsSuffix suffix, TranslatorState state) throws SterlingException {
        return this.visitTail(suffix.getTail(), state);
    }

    @Override
    public Expression visitIndexerArgumentsTail(IndexerArgumentsTail tail, TranslatorState state) throws SterlingException {
        return this.join(tail.getArgument(), tail.getSuffix(), state);
    }

    @Override
    public Expression visitIndexerExpression(IndexerExpression indexer, TranslatorState state) throws SterlingException {
        state.pushExpression(ExpressionFactory.access(state.popExpression(), ExpressionFactory.symbol("[]")));
        return this.visit(indexer.getArguments(), state);
    }

    @Override
    public Expression visitIntegerLiteral(IntegerLiteral integer, TranslatorState state) throws SterlingException {
        return ExpressionFactory.constant(((IntegerToken)integer.getLiteral()).getIntValue());
    }

    @Override
    public Expression visitLambdaArgument(LambdaArgument argument, TranslatorState state) throws SterlingException {
        return ExpressionFactory.variable(argument.getValue());
    }

    @Override
    public Expression visitLambdaLiteral(LambdaLiteral lambda, TranslatorState state) throws SterlingException {
        return ExpressionFactory.lambda(state.define((Variable)this.visit(lambda.getArgument(), state)), this.visitLambdaArguments(lambda.getExpression(), state));
    }

    @Override
    public Expression visitLiteralExpression(LiteralExpression literal, TranslatorState state) throws SterlingException {
        return this.visit(literal.getOperand(), state);
    }

    @Override
    public Expression visitModuleDeclaration(ModuleDeclaration module, TranslatorState state) throws SterlingException {
        this.visit(module.getModuleHeader(), state);
        this.visit(module.getUseHeaders(), state);
        this.visit(module.getDeclarations(), state);
        return null;
    }

    @Override
    public Expression visitModuleHeader(ModuleHeader header, TranslatorState state) throws SterlingException {
        if (header.isDeclared()) {
            this.visit(header.getIdentifier(), state);
            state.acceptModule();
        }
        return null;
    }

    @Override
    public Expression visitModuleIdentifier(ModuleIdentifier identifier, TranslatorState state) throws SterlingException {
        state.appendModule(identifier.getValue());
        this.visit(identifier.getTail(), state);
        return null;
    }

    @Override
    public Expression visitModuleIdentifierTail(ModuleIdentifierTail tail, TranslatorState state) throws SterlingException {
        state.appendModule(tail.getValue());
        this.visit(tail.getTail(), state);
        return null;
    }

    @Override
    public Expression visitNullLiteral(NullLiteral literal, TranslatorState state) throws SterlingException {
        return ExpressionFactory.nothing();
    }

    @Override
    public Expression visitObjectArgument(ObjectArgument argument, TranslatorState state) throws SterlingException {
        return ExpressionFactory.variable(argument.getValue());
    }

    @Override
    public Expression visitObjectArguments(ObjectArguments arguments, TranslatorState state) throws SterlingException {
        if (arguments.hasList()) {
            return this.visit(arguments.getList(), state);
        }
        return this.visit(state.popSource(), state);
    }

    @Override
    public Expression visitObjectArgumentsList(ObjectArgumentsList arguments, TranslatorState state) throws SterlingException {
        return ExpressionFactory.lambda(state.define((Variable)this.visit(arguments.getArgument(), state)), this.visitLambdaArguments(arguments.getList(), state));
    }

    @Override
    public Expression visitObjectBody(ObjectBody body, TranslatorState state) throws SterlingException {
        return this.visit(body.getMembers(), state);
    }

    @Override
    public Expression visitObjectHeader(ObjectHeader header, TranslatorState state) throws SterlingException {
        if (header.isDeclared()) {
            return this.visit(header.getArguments(), state);
        }
        return this.visit(state.popSource(), state);
    }

    @Override
    public Expression visitObjectLiteral(ObjectLiteral literal, TranslatorState state) throws SterlingException {
        state.pushSource(literal.getBody());
        state.enterScope();
        Expression expression = this.visit(literal.getHeader(), state);
        state.leaveScope();
        return expression;
    }

    @Override
    public Expression visitObjectMember(ObjectMember member, TranslatorState state) throws SterlingException {
        state.declareMember(member.getName(), this.visit(member.getLambda(), state));
        return null;
    }

    @Override
    public Expression visitObjectMemberName(ObjectMemberName name, TranslatorState state) throws SterlingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression visitObjectMembers(ObjectMembers members, TranslatorState state) throws SterlingException {
        state.beginObject();
        this.visit(members.getMember(), state);
        this.visit(members.getSuffix(), state);
        return state.acceptObject();
    }

    @Override
    public Expression visitObjectMembersSuffix(ObjectMembersSuffix suffix, TranslatorState state) throws SterlingException {
        return this.visit(suffix.getTail(), state);
    }

    @Override
    public Expression visitObjectMembersTail(ObjectMembersTail tail, TranslatorState state) throws SterlingException {
        this.visit(tail.getMember(), state);
        this.visit(tail.getSuffix(), state);
        return null;
    }

    @Override
    public Expression visitParentheticalExpression(ParentheticalExpression parenthetical, TranslatorState state) throws SterlingException {
        return this.visit(parenthetical.getOperand(), state);
    }

    @Override
    public Expression visitPrimaryExpression(PrimaryExpression primary, TranslatorState state) throws SterlingException {
        return this.visit(primary.getOperand(), state);
    }

    @Override
    public Expression visitQualifiedIdentifier(QualifiedIdentifier qualified, TranslatorState state) throws SterlingException {
        return this.join(state.reference(qualified.getIdentifier().getValue()), qualified.getTail(), state);
    }

    @Override
    public Expression visitQualifiedIdentifierTail(QualifiedIdentifierTail tail, TranslatorState state) throws SterlingException {
        state.pushExpression(ExpressionFactory.access(state.popExpression(), ExpressionFactory.symbol(tail.getIdentifier().getValue())));
        if (tail.hasTail()) {
            return this.visit(tail.getTail(), state);
        }
        return state.popExpression();
    }

    @Override
    public Expression visitSelectorExpression(SelectorExpression selector, TranslatorState state) throws SterlingException {
        return this.join(selector.getOperand(), selector.getTail(), state);
    }

    @Override
    public Expression visitSelectorExpressionTail(SelectorExpressionTail tail, TranslatorState state) throws SterlingException {
        return this.join(tail.getOperand(), tail.getTail(), state);
    }

    @Override
    public Expression visitSingleObjectArgument(SingleObjectArgument argument, TranslatorState state) throws SterlingException {
        return ExpressionFactory.lambda(state.define((Variable)this.visit(argument.getArgument(), state)), this.visit(state.popSource(), state));
    }

    @Override
    public Expression visitStringLiteral(StringLiteral literal, TranslatorState state) throws SterlingException {
        return ExpressionFactory.constant(((StringToken)literal.getLiteral()).getStringValue());
    }

    @Override
    public Expression visitTernaryExpression(TernaryExpression ternary, TranslatorState state) throws SterlingException {
        return ExpressionFactory.conditional(this.visit(ternary.getCondition(), state), this.visit(ternary.getTruePath(), state), this.visit(ternary.getFalsePath(), state));
    }

    @Override
    public Expression visitTernaryExpressionTail(TernaryExpressionTail tail, TranslatorState state) throws SterlingException {
        return this.visit(tail.getExpression(), state);
    }

    @Override
    public Expression visitUnaryExpression(UnaryExpression unary, TranslatorState state) throws SterlingException {
        return this.visitUnaryExpression(this.visit(unary.getOperand(), state), unary);
    }

    private Expression join(SourceNode primary, SourceNode maybe, TranslatorState state) throws SterlingException {
        return this.join(this.visit(primary, state), maybe, state);
    }

    private Expression join(Expression tree, SourceNode maybe, TranslatorState state) throws SterlingException {
        state.pushExpression(tree);
        if (maybe.isEmpty()) {
            return state.popExpression();
        }
        return this.visit(maybe, state);
    }

    private Expression visitLambdaArguments(SourceNode list, TranslatorState state) throws SterlingException {
        if (list.isEmpty()) {
            return this.visit(state.popSource(), state);
        }
        return this.visit(list, state);
    }

    private Expression visitTail(SourceNode tail, TranslatorState state) throws SterlingException {
        if (tail.isEmpty()) {
            return state.popExpression();
        }
        return this.visit(tail, state);
    }

    private Expression visitUnaryExpression(Expression operand, UnaryExpression unary) throws SterlingException {
        if (unary.hasOperator()) {
            String name = unary.getOperator().getValue();
            if ("+".equals(name)) {
                name = "positive";
            } else if ("-".equals(name)) {
                name = "negative";
            }
            return ExpressionFactory.access(operand, ExpressionFactory.symbol(name));
        }
        return operand;
    }
}

