/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.translator;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.Repository;
import org.sterling.runtime.expression.Variable;
import org.sterling.source.syntax.SourceNode;
import org.sterling.source.translator.Alias;
import org.sterling.source.translator.AliasBuilder;
import org.sterling.source.translator.ModuleBuilder;
import org.sterling.source.translator.ObjectBuilder;

public class TranslatorState {
    private final Repository repository;
    private final ModuleBuilder module;
    private final Set<DeclaredExpression> declarations;
    private final Deque<Expression> expressions;
    private final Deque<Scope> scopes;
    private final Deque<SourceNode> trees;
    private final AliasBuilder importBuilder;
    private final Map<String, String> imports;
    private final Deque<ObjectBuilder> objects;

    public TranslatorState(Repository repository) {
        this.repository = repository;
        this.module = new ModuleBuilder();
        this.declarations = new HashSet<DeclaredExpression>();
        this.expressions = new ArrayDeque<Expression>();
        this.scopes = new ArrayDeque<Scope>();
        this.trees = new ArrayDeque<SourceNode>();
        this.importBuilder = new AliasBuilder();
        this.imports = new HashMap<String, String>();
        this.objects = new ArrayDeque<ObjectBuilder>();
        this.scopes.push(new Scope());
    }

    public void acceptImports() {
        for (Alias alias : this.importBuilder.acceptImports()) {
            this.imports.put(alias.getAlias(), alias.getIdentifier());
        }
    }

    public void acceptModule() {
        this.module.acceptModule();
    }

    public Expression acceptObject() {
        return this.objects.pop().toObject();
    }

    public void addImport(String importName) {
        this.importBuilder.addImport(importName);
    }

    public void appendFrom(String part) {
        this.importBuilder.appendFrom(part);
    }

    public void appendModule(String part) {
        this.module.appendModule(part);
    }

    public void beginObject() {
        this.objects.push(new ObjectBuilder());
    }

    public void declare(String identifier, Expression expression) throws SterlingException {
        this.declarations.add(ExpressionFactory.declaration(this.qualifyDeclaration(identifier), expression));
    }

    public void declareMember(String identifier, Expression expression) {
        this.objects.peek().declareMember(identifier, expression);
    }

    public Variable define(Variable variable) {
        return this.scope().define(variable);
    }

    public void enterScope() {
        this.scopes.add(new Scope());
    }

    public Set<DeclaredExpression> getDeclarations() {
        return new HashSet<DeclaredExpression>(this.declarations);
    }

    public void leaveScope() {
        this.scopes.pop();
    }

    public Expression popExpression() {
        return this.expressions.pop();
    }

    public SourceNode popSource() {
        return this.trees.pop();
    }

    public void pushExpression(Expression expression) {
        this.expressions.push(expression);
    }

    public void pushSource(SourceNode tree) {
        this.trees.push(tree);
    }

    public Expression reference(String identifier) {
        if (this.scope().has(identifier)) {
            return this.scope().get(identifier);
        }
        return ExpressionFactory.reference(this.qualifyIdentifier(identifier), this.repository);
    }

    public void setAlias(String alias) {
        this.importBuilder.setAlias(alias);
    }

    private Scope scope() {
        return this.scopes.peek();
    }

    private String qualifyDeclaration(String identifier) {
        if (this.module.isDeclared()) {
            return this.module.getIdentifier() + "/" + identifier;
        }
        return identifier;
    }

    private String qualifyIdentifier(String identifier) {
        if (this.imports.containsKey(identifier)) {
            return this.imports.get(identifier);
        }
        return this.qualifyDeclaration(identifier);
    }

    private static final class Scope {
        private final Map<String, Variable> variables = new HashMap<String, Variable>();

        public Variable define(Variable variable) {
            this.variables.put(variable.getIdentifier(), variable);
            return variable;
        }

        public Expression get(String identifier) {
            return this.variables.get(identifier);
        }

        public boolean has(String identifier) {
            return this.variables.containsKey(identifier);
        }
    }
}

