/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.sterling.cli.CommandLineRunner;

public final class MainRunner {
    private static final String HELP = "help";
    private static final String RUN = "run";
    private final Iterable<CommandLineRunner> runners;
    private final PrintStream out;
    private final CommandLineRunner helpRunner;

    public static void main(String[] args) {
        new MainRunner().run(new ArrayList<String>(Arrays.asList(args)));
    }

    public MainRunner() {
        this.out = System.out;
        this.runners = ServiceLoader.load(CommandLineRunner.class);
        this.helpRunner = new HelpRunner();
    }

    public MainRunner(PrintStream out, Collection<CommandLineRunner> runners) {
        this.out = out;
        this.runners = new ArrayList<CommandLineRunner>(runners);
        this.helpRunner = new HelpRunner();
    }

    public void run(List<String> args) {
        if (args.isEmpty()) {
            this.requireCommand();
            args.add(HELP);
        }
        this.runCommand(args);
    }

    private CommandLineRunner getRunner(String command) {
        for (CommandLineRunner runner : this.runners) {
            if (!command.equals(runner.getCommand())) continue;
            return runner;
        }
        return null;
    }

    private void requireCommand() {
        this.out.println("No command specified.");
        this.out.println();
    }

    private void runCommand(List<String> args) {
        String command = args.get(0);
        CommandLineRunner runner = this.getRunner(command);
        if (runner == null) {
            runner = this.getRunner(RUN);
            if (runner == null) {
                this.out.println("No handler for command '" + command + "'");
                runner = this.helpRunner;
            }
            runner.run(args);
        } else {
            runner.run(args.subList(1, args.size()));
        }
    }

    private final class HelpRunner
    implements CommandLineRunner {
        private HelpRunner() {
        }

        @Override
        public String getCommand() {
            return MainRunner.HELP;
        }

        @Override
        public String getHelpText() {
            return "Displays this help message";
        }

        @Override
        public void run(List<String> args) {
            MainRunner.this.out.println("Available commands:");
            MainRunner.this.out.println();
            HashMap<String, String> helps = new HashMap<String, String>();
            int length = this.processHelps(helps);
            for (Map.Entry entry : helps.entrySet()) {
                String command = this.pad((String)entry.getKey() + ":", length + 1);
                String helpText = (String)entry.getValue();
                MainRunner.this.out.println("\t" + command + " \t" + helpText);
            }
            MainRunner.this.out.println();
        }

        private String pad(String text, int length) {
            return String.format("%1$-" + length + "s", text);
        }

        private int processHelps(Map<String, String> helps) {
            int length = 0;
            for (CommandLineRunner runner : MainRunner.this.runners) {
                String command = runner.getCommand();
                length = Math.max(length, command.length());
                helps.put(command, runner.getHelpText());
            }
            return length;
        }
    }
}

