/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.HashSet;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.AccessedExpression;
import org.sterling.runtime.expression.AppliedExpression;
import org.sterling.runtime.expression.Argument;
import org.sterling.runtime.expression.BoundExpression;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Lambda;
import org.sterling.runtime.expression.ObjectExpression;
import org.sterling.runtime.expression.Reference;

public class ArgumentBinder
implements ExpressionVisitor<Expression, Argument> {
    private static final ArgumentBinder INSTANCE = new ArgumentBinder();

    public static Expression bindArgument(Expression expression, Argument argument) throws SterlingException {
        return INSTANCE.visit(expression, argument);
    }

    private ArgumentBinder() {
    }

    @Override
    public Expression visit(Expression expression, Argument argument) throws SterlingException {
        return expression.accept(this, argument);
    }

    @Override
    public Expression visitAccessExpression(AccessedExpression expression, Argument argument) throws SterlingException {
        return ExpressionFactory.access(this.visit(expression.getExpression(), argument), this.visit(expression.getMember(), argument));
    }

    @Override
    public Expression visitApplyExpression(AppliedExpression expression, Argument argument) throws SterlingException {
        return ExpressionFactory.apply(this.visit(expression.getExpression(), argument), this.visit(expression.getArgument(), argument));
    }

    @Override
    public Expression visitArgumentExpression(Argument expression, Argument argument) throws SterlingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression visitBindExpression(BoundExpression expression, Argument argument) throws SterlingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression visitLambda(Lambda lambda, Argument argument) throws SterlingException {
        if (argument.isApplicableTo(lambda)) {
            return ExpressionFactory.lambda(lambda.getVariable(), this.visit(lambda.getExpression(), argument));
        }
        return lambda;
    }

    @Override
    public Expression visitObjectExpression(ObjectExpression object, Argument argument) throws SterlingException {
        HashSet<DeclaredExpression> declarations = new HashSet<DeclaredExpression>();
        for (DeclaredExpression declaration : object.getMembers()) {
            declarations.add(ExpressionFactory.declaration(declaration.getSymbol(), this.visit(declaration.getExpression(), argument)));
        }
        return new ObjectExpression(declarations);
    }

    @Override
    public Expression visitPrimaryExpression(Expression expression, Argument argument) throws SterlingException {
        if (argument.replaces(expression)) {
            return argument.getExpression();
        }
        return expression;
    }

    @Override
    public Expression visitReference(Reference reference, Argument data) throws SterlingException {
        return this.visit(reference.reduce(), data);
    }
}

