/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Argument;
import org.sterling.runtime.expression.ArgumentBinder;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.util.StringUtil;

public class BoundExpression
extends Expression {
    private final Expression expression;
    private final Argument argument;

    public BoundExpression(Expression expression, Argument argument) {
        this.expression = expression;
        this.argument = argument;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitBindExpression(this, data);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        return this.reduce().access(member);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return this.reduce().apply(argument);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BoundExpression) {
            BoundExpression other = (BoundExpression)o;
            return Objects.equals(this.expression, other.expression) && Objects.equals(this.argument, other.argument);
        }
        return false;
    }

    public Argument getArgument() {
        return this.argument;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.argument);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return ArgumentBinder.bindArgument(this.expression, this.argument);
    }

    public String toString() {
        return StringUtil.stringify(this, this.expression, this.argument);
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}

