/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;

public class Conditional
extends Expression {
    public static final Conditional INSTANCE = new Conditional();

    private Conditional() {
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        if (ExpressionConversions.convertBoolean(argument.evaluate()).isTrue()) {
            return new TruePick();
        }
        return new SkipPick(new FalsePick());
    }

    private static final class SkipPick
    extends Expression {
        private final Expression expression;

        public SkipPick(Expression expression) {
            this.expression = expression;
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return this.expression;
        }
    }

    private static final class FalsePick
    extends Expression {
        private FalsePick() {
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return argument.reduce();
        }
    }

    private static final class TruePick
    extends Expression {
        private TruePick() {
        }

        @Override
        public Expression apply(Expression argument) throws SterlingException {
            return new SkipPick(argument);
        }
    }
}

