/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.exception.AppliedExpressionException;
import org.sterling.runtime.exception.UndefinedMemberException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Symbol;

public abstract class Expression {
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitPrimaryExpression(this, data);
    }

    public Expression access(Expression member) throws SterlingException {
        Symbol symbol = ExpressionConversions.convertSymbol(member);
        switch (symbol.getValue()) {
            case "isNothing": {
                return BooleanConstant.FALSE;
            }
            case "toString": {
                return ExpressionFactory.constant(this.toString());
            }
        }
        throw new UndefinedMemberException("Expression '" + this.getName() + "' does not define member '" + symbol.getValue() + "'");
    }

    public Expression apply(Expression argument) throws SterlingException {
        throw new AppliedExpressionException("Cannot apply arguments to '" + this.getName() + "' expression");
    }

    public Expression evaluate() throws SterlingException {
        Expression expression = this.reduce();
        while (expression.isReducible()) {
            expression = expression.reduce();
        }
        return expression;
    }

    public Expression reduce() throws SterlingException {
        return this;
    }

    protected boolean isReducible() {
        return false;
    }

    private String getName() {
        return this.getClass().getSimpleName();
    }
}

