/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.DoubleConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.runtime.expression.StringConstant;
import org.sterling.runtime.expression.Symbol;

public final class ExpressionConversions {
    public static BooleanConstant convertBoolean(Expression expression) throws SterlingException {
        return (BooleanConstant)ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("toBoolean")).evaluate();
    }

    public static DoubleConstant convertDouble(Expression expression) throws SterlingException {
        return (DoubleConstant)ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("toDouble")).evaluate();
    }

    public static IntegerConstant convertInteger(Expression expression) throws SterlingException {
        return (IntegerConstant)ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("toInteger")).evaluate();
    }

    public static StringConstant convertString(Expression expression) throws SterlingException {
        return (StringConstant)ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("toString")).evaluate();
    }

    public static Symbol convertSymbol(Expression expression) throws SterlingException {
        if (expression instanceof Symbol) {
            return (Symbol)expression;
        }
        return (Symbol)ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("toSymbol")).evaluate();
    }

    public static boolean isNothing(Expression expression) throws SterlingException {
        return ExpressionConversions.convertBoolean(ExpressionFactory.access(expression.evaluate(), ExpressionFactory.symbol("isNothing")).evaluate()).isTrue();
    }

    private ExpressionConversions() {
    }
}

