/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.util.StringUtil;

public class JavaExpression
extends Expression {
    public static final JavaExpression JAVA = new JavaExpression();

    private JavaExpression() {
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return this.loadExpression(ExpressionConversions.convertString(argument).getValue());
    }

    public String toString() {
        return StringUtil.stringify(this, new Object[0]);
    }

    private Expression loadExpression(String className) throws SterlingException {
        try {
            Class<?> klass = this.getClass().getClassLoader().loadClass(className);
            if (Expression.class.isAssignableFrom(klass)) {
                return (Expression)klass.newInstance();
            }
            throw new SterlingException("Cannot load non-expression Java class '" + className + "'");
        }
        catch (ReflectiveOperationException exception) {
            throw new SterlingException(exception);
        }
    }
}

