/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ObjectExpression;

public class MemberExpression
extends Expression {
    private final ObjectExpression owner;
    private final Expression member;

    public MemberExpression(ObjectExpression owner, Expression member) {
        this.owner = owner;
        this.member = member;
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return this.reduce().apply(argument);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        return this.reduce().access(member);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof MemberExpression && Objects.equals(this.member, ((MemberExpression)o).member);
    }

    public int hashCode() {
        return Objects.hash(this.member);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return ExpressionFactory.lambda(ExpressionFactory.SELF, this.member).apply(this.owner);
    }

    public String toString() {
        return this.member.toString();
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}

