/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.sterling.SterlingException;
import org.sterling.runtime.GlobalModule;
import org.sterling.runtime.exception.UndefinedMemberException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.Symbol;
import org.sterling.util.StringUtil;

public class ModuleExpression
extends Expression {
    private final Symbol symbol;
    private final Map<Symbol, DeclaredExpression> members;
    private final Set<Symbol> loadedMembers;
    private final GlobalModule loader;

    private static Map<Symbol, DeclaredExpression> processMembers(Set<DeclaredExpression> members) {
        HashMap<Symbol, DeclaredExpression> map = new HashMap<Symbol, DeclaredExpression>();
        for (DeclaredExpression declaration : members) {
            map.put(declaration.getSymbol(), declaration);
        }
        return map;
    }

    public ModuleExpression(Symbol symbol, GlobalModule loader, Set<DeclaredExpression> members) {
        this.symbol = symbol;
        this.loader = loader;
        this.members = new ConcurrentHashMap<Symbol, DeclaredExpression>(ModuleExpression.processMembers(members));
        this.loadedMembers = new CopyOnWriteArraySet<Symbol>();
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        Symbol symbol = ExpressionConversions.convertSymbol(member);
        if (!this.isDefined(symbol)) {
            try {
                return super.access(member);
            }
            catch (UndefinedMemberException exception) {
                this.load(symbol);
            }
        }
        return this.members.get(symbol).getExpression();
    }

    public String toString() {
        return StringUtil.stringify(this, this.symbol);
    }

    private Symbol getModuleName(Symbol subModule) {
        return ExpressionFactory.symbol(this.symbol.getValue() + "/" + subModule.getValue());
    }

    private boolean isDefined(Symbol symbol) {
        return this.members.containsKey(symbol);
    }

    private void load(Symbol subModule) throws SterlingException {
        if (!this.loadedMembers.contains(subModule)) {
            this.loadedMembers.add(subModule);
            this.members.put(subModule, ExpressionFactory.declaration(subModule, (Expression)this.loader.loadModule(this.getModuleName(subModule))));
        }
    }
}

