/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.GlobalModule;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Symbol;
import org.sterling.util.StringUtil;

public class Reference
extends Expression {
    private final Symbol symbol;
    private final GlobalModule globalModule;

    public Reference(Symbol symbol) {
        this.symbol = symbol;
        this.globalModule = null;
    }

    public Reference(Symbol symbol, GlobalModule globalModule) {
        this.symbol = symbol;
        this.globalModule = globalModule;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitReference(this, data);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return this.reduce().apply(argument);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Reference && Objects.equals(this.symbol, ((Reference)o).symbol);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public int hashCode() {
        return Objects.hash(this.symbol);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return this.globalModule.load(this.symbol.getValue());
    }

    public String toString() {
        return StringUtil.stringify(this, "'" + this.symbol + "'");
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}

