/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.exception.ConversionException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.util.StringUtil;

public class StringConstant
extends Expression {
    private final String value;

    public StringConstant(String value) {
        this.value = value;
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "+": {
                return new ConcatenateClosure(this.value);
            }
            case "toSymbol": {
                return ExpressionFactory.symbol(this.value);
            }
            case "toBoolean": {
                return this.toBoolean();
            }
            case "toInteger": {
                return this.toInteger();
            }
            case "toString": {
                return this;
            }
        }
        return super.access(member);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof StringConstant && Objects.equals(this.value, ((StringConstant)o).value);
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return StringUtil.stringify(this, '\"' + this.value + '\"');
    }

    private BooleanConstant toBoolean() {
        return "true".equalsIgnoreCase(this.value) ? BooleanConstant.TRUE : BooleanConstant.FALSE;
    }

    private IntegerConstant toInteger() throws SterlingException {
        try {
            return ExpressionFactory.constant(Integer.valueOf(this.value));
        }
        catch (NumberFormatException exception) {
            throw new ConversionException(exception);
        }
    }

    private static final class ConcatenateClosure
    extends Expression {
        private final String value;

        public ConcatenateClosure(String value) {
            this.value = value;
        }

        @Override
        public Expression apply(Expression operand) throws SterlingException {
            return new StringConstant(this.value + ExpressionConversions.convertString(operand).value);
        }

        public String toString() {
            return StringUtil.stringify(this, '\"' + this.value + '\"');
        }
    }
}

