/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source;

import java.util.Objects;

public class Location
implements Comparable<Location> {
    public static final String DEFAULT_SOURCE = "NULL";
    public static final Location NULL = Location.at("NULL", -1, -1);
    private final String source;
    private final int line;
    private final int column;

    public static Location at(int line, int column) {
        return Location.at(DEFAULT_SOURCE, line, column);
    }

    public static Location at(String source, int line, int column) {
        return new Location(source, line, column);
    }

    public Location(String source, int line, int column) {
        this.source = source;
        this.line = line;
        this.column = column;
    }

    @Override
    public int compareTo(Location other) {
        if (this.line == other.line) {
            return this.column - other.column;
        }
        return this.line - other.line;
    }

    public boolean equals(Object o) {
        boolean matches = false;
        if (o == this) {
            matches = true;
        } else if (o instanceof Location) {
            Location other = (Location)o;
            matches = Objects.equals(this.source, other.source) && Objects.equals(this.line, other.line) && Objects.equals(this.column, other.column);
        }
        return matches;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLine() {
        return this.line;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return Objects.hash(this.source, this.line, this.column);
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public String toString() {
        return "'" + this.source + "' (" + (this.line + 1) + ", " + (this.column + 1) + ")";
    }
}

