/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.sterling.source.Location;
import org.sterling.source.LocationAware;

public class LocationRange
implements LocationAware {
    public static final LocationRange NULL = new LocationRange(Location.NULL, Location.NULL);
    private final Location start;
    private final Location end;

    public static LocationRange between(Location start, Location end) {
        return new LocationRange(start, end);
    }

    public static LocationRange extent(Collection<? extends LocationAware> locations) {
        ArrayList<Location> startLocations = new ArrayList<Location>();
        ArrayList<Location> endLocations = new ArrayList<Location>();
        for (LocationAware locationAware : locations) {
            LocationRange range = locationAware.getRange();
            if (range.isNull()) continue;
            if (!range.getStart().isNull()) {
                startLocations.add(range.getStart());
            }
            if (range.getEnd().isNull()) continue;
            endLocations.add(range.getEnd());
        }
        return LocationRange.between((Location)Collections.min(startLocations), (Location)Collections.max(endLocations));
    }

    public static LocationRange extent(LocationAware ... locations) {
        return LocationRange.extent(Arrays.asList(locations));
    }

    public LocationRange(Location start) {
        this(start, start);
    }

    public LocationRange(Location start, Location end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationRange) {
            LocationRange other = (LocationRange)o;
            return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
        }
        return false;
    }

    public Location getEnd() {
        return this.end;
    }

    @Override
    public LocationRange getRange() {
        return this;
    }

    public Location getStart() {
        return this.start;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public String toString() {
        String value = "'" + this.start.getSource() + "' (" + (this.start.getLine() + 1) + ", " + (this.start.getColumn() + 1) + ")";
        if (this.start.equals(this.end)) {
            return value;
        }
        return value + ", (" + (this.end.getLine() + 1) + ", " + (this.end.getColumn() + 1) + ")";
    }
}

