/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.scanner.EscapeUtil;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.CharacterToken;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class CharacterScanner
implements ScannerDelegate {
    private final Pattern asciiEscape = Pattern.compile("^\\\\[btnfr\"'\\\\]");
    private final Pattern hexEscape = Pattern.compile("^\\\\[uU][a-fA-F0-9]{4}");
    private final Pattern octalEscape = Pattern.compile("^\\\\[0-3]?[0-7]{2}");

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect('\'');
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (!this.expect(kind, reader)) {
            throw ScannerUtil.unexpectedInput(reader, kind);
        }
        reader.store();
        if (!reader.store(this.asciiEscape, this.hexEscape, this.octalEscape)) {
            this.validateEscapeSequence(kind, reader);
            reader.store();
        }
        if (!reader.expect('\'')) {
            throw ScannerUtil.unterminatedCharacter(reader, kind);
        }
        reader.store();
        Token token = reader.accept(kind);
        char charValue = EscapeUtil.unescapeString(token.getValue()).charAt(1);
        return new CharacterToken(token, charValue);
    }

    private void validateEscapeSequence(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.expect('\\')) {
            throw ScannerUtil.invalidEscapeSequence(reader, kind);
        }
        if (reader.expect('\'')) {
            throw ScannerUtil.unexpectedInput(reader, kind);
        }
        if (reader.expect('\n')) {
            throw ScannerUtil.unterminatedCharacter(reader, kind);
        }
    }
}

