/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

public final class EscapeUtil {
    public static String unescapeString(String escapedString) {
        StringBuilder unescapedString = new StringBuilder(escapedString.length());
        boolean backslash = false;
        for (int position = 0; position < escapedString.length(); ++position) {
            int codePoint = escapedString.codePointAt(position);
            if (escapedString.codePointAt(position) > 65535) {
                ++position;
            }
            if (!backslash) {
                if (codePoint == 92) {
                    backslash = true;
                    continue;
                }
                unescapedString.append(Character.toChars(codePoint));
                continue;
            }
            if (codePoint == 92) {
                backslash = false;
                unescapedString.append('\\');
                unescapedString.append('\\');
                continue;
            }
            switch (codePoint) {
                case 114: {
                    unescapedString.append('\r');
                    break;
                }
                case 110: {
                    unescapedString.append('\n');
                    break;
                }
                case 102: {
                    unescapedString.append('\f');
                    break;
                }
                case 98: {
                    unescapedString.append('\b');
                    break;
                }
                case 116: {
                    unescapedString.append('\t');
                    break;
                }
                case 56: 
                case 57: {
                    throw new IllegalArgumentException("Illegal octal escape in string at position " + position);
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --position;
                }
                case 48: {
                    char point;
                    if (position == escapedString.length() - position) {
                        unescapedString.append(Character.toChars(0));
                        break;
                    }
                    ++position;
                    int offset = 0;
                    for (int j = 0; j <= 2 && position != escapedString.length() - j && (point = escapedString.charAt(position + j)) >= '0' && point <= '7'; ++j) {
                        ++offset;
                    }
                    if (offset == 0) {
                        --position;
                        unescapedString.append('\u0000');
                        break;
                    }
                    unescapedString.append(Character.toChars(Integer.parseInt(escapedString.substring(position, position + offset), 8)));
                    position += offset - 1;
                    break;
                }
                case 117: {
                    int offset;
                    if (position + 4 > escapedString.length()) {
                        throw new IllegalArgumentException("Illegal length of \\u escape in string at position " + position);
                    }
                    ++position;
                    for (offset = 0; offset < 4; ++offset) {
                        if (escapedString.charAt(position + offset) <= '\u007f') continue;
                        throw new IllegalArgumentException("Illegal non-ASCII hex digit in \\u escape at position " + position);
                    }
                    unescapedString.append(Character.toChars(Integer.parseInt(escapedString.substring(position, position + offset), 16)));
                    position += offset - 1;
                    break;
                }
                default: {
                    unescapedString.append('\\');
                    unescapedString.append(Character.toChars(codePoint));
                }
            }
            backslash = false;
        }
        if (backslash) {
            unescapedString.append('\\');
        }
        return unescapedString.toString();
    }

    private EscapeUtil() {
    }
}

