/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import org.sterling.SterlingException;
import org.sterling.source.LocationRange;
import org.sterling.source.exception.ScannerException;
import org.sterling.source.scanner.Scanner;
import org.sterling.source.scanner.StateManager;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class ListScanner
implements Scanner {
    private final Deque<Token> tokens;
    private final StateManager<Token> transactions;

    public ListScanner(List<Token> tokens) {
        this.tokens = new ArrayDeque<Token>(tokens);
        this.transactions = new StateManager<Token>(this.tokens);
        this.tokens.add(Token.token(NodeKind.END_OF_INPUT, "\u0000", LocationRange.NULL));
    }

    @Override
    public void begin() {
        this.transactions.begin();
    }

    @Override
    public void close() {
        this.transactions.close();
        this.tokens.clear();
    }

    @Override
    public void end() {
        this.transactions.end();
    }

    @Override
    public boolean expect(NodeKind kind) {
        Token token = this.tokens.peek();
        if (token == null) {
            token = Token.NULL;
        }
        return token.is(kind);
    }

    @Override
    public boolean expectOne(NodeKind ... kinds) {
        return this.expectOne(Arrays.asList(kinds));
    }

    @Override
    public boolean expectOne(Iterable<NodeKind> kinds) {
        return NodeKind.ANYTHING != this.expected(kinds);
    }

    @Override
    public NodeKind expected(NodeKind ... kinds) {
        return this.expected(Arrays.asList(kinds));
    }

    @Override
    public NodeKind expected(Iterable<NodeKind> kinds) {
        for (NodeKind kind : kinds) {
            if (!this.expect(kind)) continue;
            return kind;
        }
        return NodeKind.ANYTHING;
    }

    @Override
    public Token require(NodeKind kind) throws SterlingException {
        if (this.expect(kind)) {
            Token next = this.tokens.poll();
            this.transactions.push(next);
            return next;
        }
        throw this.unexpectedToken();
    }

    @Override
    public Token requireOne(NodeKind ... kinds) throws SterlingException {
        return this.requireOne(Arrays.asList(kinds));
    }

    @Override
    public Token requireOne(Collection<NodeKind> kinds) throws SterlingException {
        for (NodeKind kind : kinds) {
            if (!this.expect(kind)) continue;
            return this.require(kind);
        }
        throw this.unexpectedToken();
    }

    @Override
    public void restore() {
        this.transactions.restore();
    }

    private ScannerException unexpectedToken() {
        return new ScannerException("Unexpected token: " + this.tokens.peek());
    }
}

