/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.source.LocationAware;
import org.sterling.source.LocationRange;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.SourceVisitor;
import org.sterling.source.syntax.Token;

public class SourceNode
implements LocationAware {
    public static final SourceNode VOID = new SourceNode();
    private final State state;
    private SourceNode parent;

    public SourceNode(NodeKind kind) {
        this.state = kind.isTerminal() ? new TerminalState(kind) : new NonTerminalState(kind, this);
    }

    private SourceNode() {
        this.state = new VoidState();
    }

    public <R, S> R accept(SourceVisitor<R, S> visitor, S state) throws SterlingException {
        return null;
    }

    public void addChild(SourceNode child) {
        this.state.addChild(child);
    }

    public boolean childOf(SourceNode parent) {
        return this.parent != null && (this.parent.equals(parent) || this.parent.childOf(parent));
    }

    public int childrenSize() {
        return this.state.childrenSize();
    }

    public void clearChildren() {
        this.state.clearChildren();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SourceNode && this.state.equals(((SourceNode)o).state);
    }

    public SourceNode getChildAt(int index) {
        return this.state.getChildAt(index);
    }

    public List<SourceNode> getChildren() {
        return this.state.getChildren();
    }

    public NodeKind getKind() {
        return this.state.getKind();
    }

    @Override
    public LocationRange getRange() {
        return this.state.getRange();
    }

    public Token getToken() {
        return this.state.getToken();
    }

    public void setToken(Token token) {
        this.state.setToken(token);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public boolean isTerminal() {
        return this.state.getKind().isTerminal();
    }

    public void prune() {
        this.state.prune();
    }

    public String toString() {
        return this.state.toString();
    }

    private static final class VoidState
    implements State {
        private VoidState() {
        }

        @Override
        public void addChild(SourceNode child) {
            throw new IllegalStateException();
        }

        @Override
        public int childrenSize() {
            throw new IllegalStateException();
        }

        @Override
        public void clearChildren() {
            throw new IllegalStateException();
        }

        @Override
        public SourceNode getChildAt(int index) {
            throw new IllegalStateException();
        }

        @Override
        public List<SourceNode> getChildren() {
            throw new IllegalStateException();
        }

        @Override
        public NodeKind getKind() {
            return NodeKind.UNDEFINED;
        }

        @Override
        public LocationRange getRange() {
            return LocationRange.NULL;
        }

        @Override
        public Token getToken() {
            throw new IllegalStateException();
        }

        @Override
        public void setToken(Token token) {
            throw new IllegalStateException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void prune() {
        }
    }

    private static final class TerminalState
    implements State {
        private final NodeKind kind;
        private Token token;

        public TerminalState(NodeKind kind) {
            this.kind = kind;
        }

        @Override
        public void addChild(SourceNode child) {
            throw new IllegalStateException();
        }

        @Override
        public int childrenSize() {
            throw new IllegalStateException();
        }

        @Override
        public void clearChildren() {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            if (o instanceof TerminalState) {
                TerminalState other = (TerminalState)o;
                return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.token, other.token);
            }
            return false;
        }

        @Override
        public SourceNode getChildAt(int index) {
            throw new IllegalStateException();
        }

        @Override
        public List<SourceNode> getChildren() {
            throw new IllegalStateException();
        }

        @Override
        public NodeKind getKind() {
            return this.kind;
        }

        @Override
        public LocationRange getRange() {
            return this.token.getRange();
        }

        @Override
        public Token getToken() {
            return this.token;
        }

        @Override
        public void setToken(Token token) {
            if (!token.is(this.kind)) {
                throw new IllegalArgumentException("Expecting token kind " + (Object)((Object)this.kind) + " but got " + (Object)((Object)token.getKind()));
            }
            this.token = token;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.token});
        }

        @Override
        public boolean isEmpty() {
            return this.token == null;
        }

        @Override
        public void prune() {
        }

        public String toString() {
            if (this.token == null) {
                return "(" + (Object)((Object)this.kind) + ")";
            }
            return "(" + (Object)((Object)this.kind) + " token=" + this.token + ")";
        }
    }

    private static final class NonTerminalState
    implements State {
        private final NodeKind kind;
        private final SourceNode node;
        private final List<SourceNode> children;

        public NonTerminalState(NodeKind kind, SourceNode node) {
            this.kind = kind;
            this.node = node;
            this.children = new ArrayList<SourceNode>();
        }

        @Override
        public void addChild(SourceNode child) {
            this.children.add(child);
            child.parent = this.node;
        }

        @Override
        public int childrenSize() {
            return this.children.size();
        }

        @Override
        public void clearChildren() {
            for (SourceNode child : this.children) {
                child.parent = null;
            }
            this.children.clear();
        }

        public boolean equals(Object o) {
            if (o instanceof NonTerminalState) {
                NonTerminalState other = (NonTerminalState)o;
                return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.children, other.children);
            }
            return false;
        }

        @Override
        public SourceNode getChildAt(int index) {
            if (index >= this.children.size()) {
                return VOID;
            }
            return this.children.get(index);
        }

        @Override
        public List<SourceNode> getChildren() {
            return new ArrayList<SourceNode>(this.children);
        }

        @Override
        public NodeKind getKind() {
            return this.kind;
        }

        @Override
        public LocationRange getRange() {
            return LocationRange.extent(this.children);
        }

        @Override
        public Token getToken() {
            throw new IllegalStateException();
        }

        @Override
        public void setToken(Token token) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.children});
        }

        @Override
        public boolean isEmpty() {
            return this.children.isEmpty();
        }

        @Override
        public void prune() {
            Iterator<SourceNode> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                SourceNode node = iterator.next();
                node.prune();
                if (!node.isEmpty()) continue;
                iterator.remove();
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('(');
            builder.append((Object)this.kind);
            Iterator<SourceNode> iterator = this.children.iterator();
            if (iterator.hasNext()) {
                builder.append(" children=[");
                builder.append(iterator.next());
                while (iterator.hasNext()) {
                    builder.append(", ");
                    builder.append(iterator.next());
                }
                builder.append(']');
            }
            builder.append(')');
            return builder.toString();
        }
    }

    private static interface State
    extends LocationAware {
        public void addChild(SourceNode var1);

        public int childrenSize();

        public void clearChildren();

        public SourceNode getChildAt(int var1);

        public List<SourceNode> getChildren();

        public NodeKind getKind();

        public Token getToken();

        public void setToken(Token var1);

        public boolean isEmpty();

        public void prune();
    }
}

