/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.syntax;

import java.io.PrintStream;
import org.sterling.source.syntax.SourceNode;
import org.sterling.source.syntax.Token;
import org.sterling.util.PrinterState;

public class SourcePrinter {
    public void print(SourceNode node, PrintStream out) {
        this.print(node, (PrinterState)new SourcePrinterState(out));
    }

    private void print(SourceNode node, PrinterState state) {
        if (node.isTerminal()) {
            this.print(node.getToken(), state);
        } else {
            state.begin(node);
            for (SourceNode child : node.getChildren()) {
                this.print(child, state);
            }
            state.end();
        }
    }

    private void print(Token value, PrinterState state) {
        state.println(value.getClass().getSimpleName() + " " + value.toString());
    }

    private static final class SourcePrinterState
    extends PrinterState {
        public SourcePrinterState(PrintStream out) {
            super(out);
        }

        @Override
        protected String formatNode(Object node) {
            return "Node " + (Object)((Object)((SourceNode)node).getKind());
        }
    }
}

