/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.syntax;

import java.util.Objects;
import org.sterling.source.LocationAware;
import org.sterling.source.LocationRange;
import org.sterling.source.syntax.NodeKind;

public class Token
implements LocationAware {
    public static final Token NULL = Token.token(NodeKind.UNDEFINED, "NULL", LocationRange.NULL);
    private final NodeKind kind;
    private final String value;
    private final LocationRange range;

    public static Token token(NodeKind kind, String value, LocationRange range) {
        return new Token(kind, value, range);
    }

    public Token(NodeKind kind, String value, LocationRange range) {
        if (!kind.isTerminal()) {
            throw new IllegalArgumentException("Token can only be non-terminal type");
        }
        this.kind = kind;
        this.value = value;
        this.range = range;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Token) {
            Token other = (Token)o;
            return this.kind == other.kind && Objects.equals(this.value, other.value) && Objects.equals(this.range, other.range);
        }
        return false;
    }

    public NodeKind getKind() {
        return this.kind;
    }

    @Override
    public LocationRange getRange() {
        return this.range;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value, this.range});
    }

    public boolean is(NodeKind kind) {
        return this.kind == kind;
    }

    public String toString() {
        return (Object)((Object)this.kind) + " '" + this.value.replace("\n", "\\n").replace("\u0000", "\\0") + "' [" + this.range + "]";
    }
}

