/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.translator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.sterling.SterlingException;
import org.sterling.cli.CommandLineRunner;
import org.sterling.cli.RunnerException;
import org.sterling.runtime.Compiler;
import org.sterling.runtime.GlobalModule;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.ExpressionPrinter;
import org.sterling.source.parser.Parser;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.Scanner;
import org.sterling.source.scanner.ScannerFactory;
import org.sterling.source.translator.Translator;

public class TranslatorRunner
implements CommandLineRunner {
    private final Parser parser = new Parser();
    private final ScannerFactory scannerFactory = new ScannerFactory();
    private final Translator translator = new Translator();
    private final ExpressionPrinter printer = new ExpressionPrinter(1);
    private final PrintStream out = System.out;

    @Override
    public String getCommand() {
        return "translate";
    }

    @Override
    public String getHelpText() {
        return "Translates a file and displays the resultant abstract syntax tree";
    }

    @Override
    public void run(List<String> args) {
        File file = this.getFile(args);
        try (InputReader inputReader = new InputReader(file.getPath(), new FileInputStream(file));){
            Scanner scanner = this.scannerFactory.getScanner(inputReader);
            GlobalModule globalModule = new GlobalModule(ClassLoader.getSystemClassLoader(), new Compiler());
            for (DeclaredExpression declaration : this.translator.translate(this.parser.parse(scanner), globalModule)) {
                this.out.println();
                this.out.println("  <<" + declaration.getSymbol() + ">>");
                this.printer.print(declaration.getExpression(), this.out);
                this.out.println();
            }
            this.out.println();
        }
        catch (IOException | SterlingException exception) {
            throw new RunnerException(exception);
        }
    }

    private File getFile(List<String> args) {
        if (args.size() < 1) {
            throw new RunnerException("No file specified");
        }
        File file = new File(args.get(0));
        if (!file.exists()) {
            throw new RunnerException("File '" + file + "' does not exist");
        }
        if (!file.isFile()) {
            throw new RunnerException("Path '" + file + "' is not a file");
        }
        return file;
    }
}

