/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.util;

import java.io.PrintStream;
import org.sterling.util.VisitorState;
import org.sterling.util.VisitorTracker;

public class PrinterState
implements VisitorState {
    private final VisitorTracker tracker = new VisitorTracker();
    private final PrintStream out;
    private int currentIndent;

    public PrinterState(PrintStream out) {
        this(out, 0);
    }

    public PrinterState(PrintStream out, int indent) {
        this.out = out;
        this.currentIndent = indent;
    }

    public void begin(Object node) {
        this.println(this.formatNode(node));
        this.indent();
    }

    @Override
    public void beginVisit(Object node) {
        this.tracker.beginVisit(node);
    }

    public void end() {
        this.dedent();
    }

    @Override
    public void endVisit(Object node) {
        this.tracker.endVisit(node);
    }

    public void println(String value) {
        this.out.print(this.getIndent());
        this.out.println("+" + value);
    }

    private void dedent() {
        --this.currentIndent;
    }

    private String getIndent() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.currentIndent; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }

    private void indent() {
        ++this.currentIndent;
    }

    protected String formatNode(Object node) {
        return node.getClass().getSimpleName();
    }
}

