package org.sterling.runtime;

import java.util.Set;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.source.parser.Parser;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerFactory;
import org.sterling.source.translator.Translator;

public class Compiler {

    private final ScannerFactory factory;
    private final Translator translator;
    private final Parser parser;

    public Compiler() {
        this.factory = new ScannerFactory();
        this.translator = new Translator();
        this.parser = new Parser();
    }

    public Set<DeclaredExpression> compile(InputReader inputReader, GlobalModule globalModule) throws SterlingException {
        return translator.translate(parser.parse(factory.getScanner(inputReader)), globalModule);
    }
}
