package org.sterling.runtime.expression;

import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;
import org.sterling.SterlingException;

public class AccessedExpression extends Expression {

    private final Expression expression;
    private final Expression member;

    public AccessedExpression(Expression expression, Expression member) {
        this.expression = expression;
        this.member = member;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitAccessExpression(this, data);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof AccessedExpression) {
            AccessedExpression other = (AccessedExpression) o;
            return Objects.equals(expression, other.expression)
                && Objects.equals(member, other.member);
        } else {
            return false;
        }
    }

    public Expression getExpression() {
        return expression;
    }

    public Expression getMember() {
        return member;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, member);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return expression.reduce().access(member);
    }

    @Override
    public String toString() {
        return stringify(this, expression, member);
    }
}
