package org.sterling.runtime.expression;

import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;
import org.sterling.SterlingException;

public class AppliedExpression extends Expression {

    private final Expression expression;
    private final Expression argument;

    public AppliedExpression(Expression expression, Expression argument) {
        this.expression = expression;
        this.argument = argument;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitApplyExpression(this, data);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        return reduce().access(member);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return reduce().apply(argument);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof AppliedExpression) {
            AppliedExpression other = (AppliedExpression) o;
            return Objects.equals(expression, other.expression)
                && Objects.equals(argument, other.argument);
        } else {
            return false;
        }
    }

    public Expression getArgument() {
        return argument;
    }

    public Expression getExpression() {
        return expression;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression, argument);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return expression.reduce().apply(argument);
    }

    @Override
    public String toString() {
        return stringify(this, expression, argument);
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}
