package org.sterling.runtime.expression;

import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;
import org.sterling.SterlingException;

public class Argument extends Expression {

    private final Variable variable;
    private final Expression expression;

    public Argument(Variable variable, Expression expression) {
        this.variable = variable;
        this.expression = expression;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitArgumentExpression(this, data);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof Argument) {
            Argument other = (Argument) o;
            return Objects.equals(variable, other.variable)
                && Objects.equals(expression, other.expression);
        } else {
            return false;
        }
    }

    public Expression getExpression() {
        return expression;
    }

    @Override
    public int hashCode() {
        return Objects.hash(variable, expression);
    }

    public boolean isApplicableTo(Lambda lambda) {
        return !variable.equals(lambda.getVariable());
    }

    public boolean replaces(Expression expression) {
        return variable.equals(expression);
    }

    @Override
    public String toString() {
        return stringify(this, variable, expression);
    }
}
