package org.sterling.runtime.expression;

import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;

public class CharacterConstant extends Expression {

    private final char value;

    public CharacterConstant(char value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof CharacterConstant && value == ((CharacterConstant) o).value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return stringify(this, "'" + value + "'");
    }
}
