package org.sterling.runtime.expression;

public class DeclaredExpression {

    private final Symbol symbol;
    private final Expression expression;

    public DeclaredExpression(Symbol symbol, Expression expression) {
        this.symbol = symbol;
        this.expression = expression;
    }

    public String getIdentifier() {
        return symbol.getValue();
    }

    public Expression getExpression() {
        return expression;
    }

    public Symbol getSymbol() {
        return symbol;
    }

    @Override
    public String toString() {
        return symbol.getValue() + "=" + expression;
    }
}
