package org.sterling.runtime.expression;

import org.sterling.SterlingException;

public interface ExpressionVisitor<R, D> {

    R visit(Expression expression, D data) throws SterlingException;

    R visitAccessExpression(AccessedExpression expression, D data) throws SterlingException;

    R visitApplyExpression(AppliedExpression expression, D data) throws SterlingException;

    R visitArgumentExpression(Argument expression, D data) throws SterlingException;

    R visitBindExpression(BoundExpression expression, D data) throws SterlingException;

    R visitLambda(Lambda lambda, D data) throws SterlingException;

    R visitObjectExpression(ObjectExpression object, D data) throws SterlingException;

    R visitPrimaryExpression(Expression expression, D data) throws SterlingException;

    R visitReference(Reference reference, D data) throws SterlingException;
}
