package org.sterling.runtime.expression;

import static org.sterling.runtime.expression.ExpressionConversions.convertString;
import static org.sterling.util.StringUtil.stringify;

import org.sterling.SterlingException;

public class JavaExpression extends Expression {

    public static final JavaExpression JAVA = new JavaExpression();

    private JavaExpression() {
        // intentionally empty
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return loadExpression(convertString(argument).getValue());
    }

    @Override
    public String toString() {
        return stringify(this);
    }

    private Expression loadExpression(String className) throws SterlingException {
        try {
            Class<?> klass = getClass().getClassLoader().loadClass(className);
            if (Expression.class.isAssignableFrom(klass)) {
                return (Expression) klass.newInstance();
            } else {
                throw new SterlingException("Cannot load non-expression Java class '" + className + "'");
            }
        } catch (ReflectiveOperationException exception) {
            throw new SterlingException(exception);
        }
    }
}
