package org.sterling.runtime.expression;

import static org.sterling.runtime.expression.ExpressionFactory.argument;
import static org.sterling.runtime.expression.ExpressionFactory.bind;
import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;
import org.sterling.SterlingException;

public class Lambda extends Expression {

    private final Expression expression;
    private final Variable variable;

    public Lambda(Variable variable, Expression expression) {
        this.expression = expression;
        this.variable = variable;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitLambda(this, data);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return bind(expression, argument(variable, argument));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof Lambda) {
            Lambda other = (Lambda) o;
            return Objects.equals(variable, other.variable)
                && Objects.equals(expression, other.expression);
        } else {
            return false;
        }
    }

    public Expression getExpression() {
        return expression;
    }

    public Variable getVariable() {
        return variable;
    }

    @Override
    public int hashCode() {
        return Objects.hash(variable, expression);
    }

    @Override
    public String toString() {
        return stringify(this, variable, expression);
    }
}
