package org.sterling.runtime.expression;

import static org.sterling.runtime.expression.ExpressionFactory.SELF;
import static org.sterling.runtime.expression.ExpressionFactory.lambda;

import java.util.Objects;
import org.sterling.SterlingException;

public class MemberExpression extends Expression {

    private final ObjectExpression owner;
    private final Expression member;

    public MemberExpression(ObjectExpression owner, Expression member) {
        this.owner = owner;
        this.member = member;
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return reduce().apply(argument);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        return reduce().access(member);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof MemberExpression && Objects.equals(member, ((MemberExpression) o).member);
    }

    @Override
    public int hashCode() {
        return Objects.hash(member);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return lambda(SELF, member).apply(owner);
    }

    @Override
    public String toString() {
        return member.toString();
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}
