package org.sterling.runtime.expression;

import static org.sterling.runtime.expression.BooleanConstant.TRUE;
import static org.sterling.runtime.expression.ExpressionConversions.convertSymbol;
import static org.sterling.runtime.expression.ExpressionFactory.constant;
import static org.sterling.util.StringUtil.stringify;

import org.sterling.SterlingException;

public class NullConstant extends Expression {

    public static final NullConstant NULL = new NullConstant();

    private final BooleanConstant booleanValue;
    private final IntegerConstant integerValue;
    private final StringConstant stringValue;

    private NullConstant() {
        booleanValue = constant(false);
        integerValue = constant(0);
        stringValue = constant("Nothing");
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (convertSymbol(member).getValue()) {
            case "isNothing": return TRUE;
            case "toBoolean": return booleanValue;
            case "toInteger": return integerValue;
            case "toString": return stringValue;
            default: return super.access(member);
        }
    }

    @Override
    public String toString() {
        return stringify(this);
    }
}
