package org.sterling.runtime.expression;

import static org.sterling.runtime.expression.ExpressionConversions.convertSymbol;
import static org.sterling.runtime.expression.ExpressionFactory.constant;
import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;
import org.sterling.SterlingException;

public class Symbol extends Expression {

    private final String value;

    public Symbol(String value) {
        this.value = value;
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (convertSymbol(member).getValue()) {
            case "toString": return constant(value);
            case "toSymbol": return this;
            default: return super.access(member);
        }
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Symbol && Objects.equals(value, ((Symbol) o).value);
    }

    public String getValue() {
        return value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return stringify(this, value);
    }
}
