package org.sterling.runtime.expression;

import static org.sterling.util.StringUtil.stringify;

import java.util.Objects;

public class Variable extends Expression {

    private final String identifier;

    public Variable(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Variable && Objects.equals(identifier, ((Variable) o).identifier);
    }

    public String getIdentifier() {
        return identifier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identifier);
    }

    @Override
    public String toString() {
        return stringify(this, identifier);
    }
}
