package org.sterling.source.parser;

import java.io.BufferedReader;
import java.io.PrintStream;
import org.sterling.source.scanner.ScannerFactory;
import org.sterling.source.syntax.SourcePrinter;

public class ParserRunnerProperties {

    private BufferedReader input;
    private PrintStream output;
    private Parser parser;
    private ScannerFactory scannerFactory;
    private SourcePrinter printer;

    public BufferedReader getInput() {
        return input;
    }

    public ParserRunnerProperties setInput(BufferedReader input) {
        this.input = input;
        return this;
    }

    public PrintStream getOutput() {
        return output;
    }

    public ParserRunnerProperties setOutput(PrintStream output) {
        this.output = output;
        return this;
    }

    public Parser getParser() {
        return parser;
    }

    public ParserRunnerProperties setParser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public ScannerFactory getScannerFactory() {
        return scannerFactory;
    }

    public ParserRunnerProperties setScannerFactory(ScannerFactory scannerFactory) {
        this.scannerFactory = scannerFactory;
        return this;
    }

    public SourcePrinter getPrinter() {
        return printer;
    }

    public ParserRunnerProperties setPrinter(SourcePrinter printer) {
        this.printer = printer;
        return this;
    }
}
