package org.sterling.source.parser;

import java.util.Objects;
import org.sterling.source.syntax.NodeKind;

public class ParserState {

    public static ParserState state(NodeKind stack, NodeKind lookAhead) {
        return new ParserState(stack, lookAhead);
    }

    private final NodeKind stack;
    private final NodeKind lookAhead;

    public ParserState(NodeKind stack, NodeKind lookAhead) {
        this.stack = stack;
        this.lookAhead = lookAhead;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (o instanceof ParserState) {
            ParserState other = (ParserState) o;
            return stack == other.stack
                && lookAhead == other.lookAhead;
        } else {
            return false;
        }
    }

    public NodeKind getLookAhead() {
        return lookAhead;
    }

    public NodeKind getStack() {
        return stack;
    }

    @Override
    public int hashCode() {
        return Objects.hash(stack, lookAhead);
    }

    @Override
    public String toString() {
        return "[" + stack + ", " + lookAhead + "]";
    }
}
