package org.sterling.source.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sterling.source.syntax.NodeKind;

public class ParserTableBuilder {

    private final Map<ParserState, ParserRule> table;

    public ParserTableBuilder() {
        table = new LinkedHashMap<>();
    }

    public void addRule(ParserRule rule) {
        if (hasState(rule)) {
            ParserState state = rule.getState();
            throw new IllegalStateException("Action already defined for stack " + state.getStack()
                + " and look-ahead " + state.getLookAhead());
        }
        table.put(rule.getState(), rule);
    }

    public ParserTable getTable() {
        return new ParserTable(table.values());
    }

    public ParserTableActionBuilder when(NodeKind stack) {
        return new ParserTableActionBuilder(this, stack);
    }

    private boolean hasState(ParserRule rule) {
        return table.containsKey(rule.getState());
    }
}
