package org.sterling.source.scanner;

import static java.lang.Boolean.parseBoolean;

import org.sterling.SterlingException;
import org.sterling.source.syntax.BooleanToken;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class BooleanScanner extends StaticTokenScanner {

    public BooleanScanner() {
        super("True\\b", "False\\b");
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        Token token = super.require(kind, reader);
        return new BooleanToken(token, parseBoolean(token.getValue()));
    }
}
