package org.sterling.source.scanner;

import static java.lang.Double.parseDouble;
import static java.util.regex.Pattern.compile;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.syntax.DoubleToken;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class DoubleScanner implements ScannerDelegate {

    private final Pattern pattern;

    public DoubleScanner() {
        pattern = compile("^(?:0(?!\\d)|[1-9][0-9]*)?\\.[\\d]+");
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(pattern);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(pattern)) {
            Token token = reader.accept(kind);
            return new DoubleToken(token, parseDouble(token.getValue()));
        } else {
            throw unexpectedInput(reader, kind);
        }
    }
}
