package org.sterling.source.scanner;

import static org.sterling.source.Location.at;
import static org.sterling.source.LocationRange.between;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;
import static org.sterling.source.syntax.Token.token;

import org.sterling.SterlingException;
import org.sterling.source.Location;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class EndOfInputScanner implements ScannerDelegate {

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect('\0');
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (expect(kind, reader)) {
            Location start = reader.getLocation();
            return token(kind, "\0", between(start, at(
                start.getSource(),
                start.getLine(),
                start.getColumn() + 1
            )));
        } else {
            throw unexpectedInput(reader, kind);
        }
    }
}
