package org.sterling.source.scanner;

import static java.util.regex.Pattern.compile;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class IdentifierScanner implements ScannerDelegate {

    private final Pattern pattern;

    public IdentifierScanner() {
        pattern = compile("^[\\p{L}_][\\p{L}\\p{N}_]*");
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(pattern);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(pattern)) {
            return reader.accept(kind);
        } else {
            throw unexpectedInput(reader, kind);
        }
    }
}
