package org.sterling.source.scanner;

import static java.lang.Integer.valueOf;
import static java.util.regex.Pattern.compile;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.syntax.IntegerToken;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class IntegerScanner implements ScannerDelegate {

    private final Pattern pattern;

    public IntegerScanner() {
        pattern = compile("^(?:0(?!\\d)|[1-9][0-9]*)");
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(pattern);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(pattern)) {
            Token token = reader.accept(kind);
            return new IntegerToken(token, valueOf(token.getValue()));
        } else {
            throw unexpectedInput(reader, kind);
        }
    }
}
