package org.sterling.source.scanner;

import java.util.Collection;
import org.sterling.SterlingException;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public interface Scanner extends AutoCloseable {

    void begin();

    @Override
    void close();

    void end();

    boolean expect(NodeKind kind);

    boolean expectOne(NodeKind... kinds);

    boolean expectOne(Iterable<NodeKind> kinds);

    NodeKind expected(NodeKind... kinds);

    NodeKind expected(Iterable<NodeKind> kinds);

    Token require(NodeKind kind) throws SterlingException;

    Token requireOne(NodeKind... kinds) throws SterlingException;

    Token requireOne(Collection<NodeKind> kinds) throws SterlingException;

    void restore();
}
