package org.sterling.source.scanner;

import static java.util.regex.Pattern.quote;

public class ScannerDelegateFactory {

    private static ScannerDelegate skipWhitespace(String... values) {
        return skipWhitespace(new StaticTokenScanner(values));
    }

    private static ScannerDelegate skipWhitespace(ScannerDelegate delegate) {
        return new WhitespaceSkippingScanner(delegate);
    }

    public ScannerDelegate getAccessorScanner() {
        return skipWhitespace(quote("."));
    }

    public ScannerDelegate getAddScanner() {
        return skipWhitespace(quote("+"));
    }

    public ScannerDelegate getApplyScanner() {
        return skipWhitespace(quote("$"));
    }

    public ScannerDelegate getArrowScanner() {
        return skipWhitespace(quote("->"));
    }

    public ScannerDelegate getAssignScanner() {
        return skipWhitespace(quote("="));
    }

    public ScannerDelegate getBitwiseAndScanner() {
        return skipWhitespace(quote("&"));
    }

    public ScannerDelegate getBitwiseNotScanner() {
        return skipWhitespace(quote("~"));
    }

    public ScannerDelegate getBitwiseOrScanner() {
        return skipWhitespace(quote("|"));
    }

    public ScannerDelegate getBitwiseXorScanner() {
        return skipWhitespace(quote("^"));
    }

    public ScannerDelegate getBlockCloseScanner() {
        return skipWhitespace(quote("}"));
    }

    public ScannerDelegate getBlockOpenScanner() {
        return skipWhitespace(quote("{"));
    }

    public ScannerDelegate getBooleanScanner() {
        return skipWhitespace(new BooleanScanner());
    }

    public ScannerDelegate getCharacterScanner() {
        return skipWhitespace(new CharacterScanner());
    }

    public ScannerDelegate getCoalesceScanner() {
        return skipWhitespace(quote("?"));
    }

    public ScannerDelegate getDivideScanner() {
        return skipWhitespace(quote("/"));
    }

    public ScannerDelegate getDoubleScanner() {
        return skipWhitespace(new DoubleScanner());
    }

    public ScannerDelegate getEndOfInputScanner() {
        return skipWhitespace(new EndOfInputScanner());
    }

    public ScannerDelegate getEqualsScanner() {
        return skipWhitespace(quote("="), "is\\b");
    }

    public ScannerDelegate getGreaterThanEqualsScanner() {
        return skipWhitespace(quote(">="));
    }

    public ScannerDelegate getGreaterThanScanner() {
        return skipWhitespace(quote(">"));
    }

    public ScannerDelegate getGroupCloseScanner() {
        return skipWhitespace(quote(")"));
    }

    public ScannerDelegate getGroupOpenScanner() {
        return skipWhitespace(quote("("));
    }

    public ScannerDelegate getIdentifierScanner() {
        return skipWhitespace(new IdentifierScanner());
    }

    public ScannerDelegate getIndexerCloseScanner() {
        return skipWhitespace(quote("]"));
    }

    public ScannerDelegate getIndexerOpenScanner() {
        return new StaticTokenScanner(quote("["));
    }

    public ScannerDelegate getIndexerOperatorScanner() {
        return skipWhitespace(quote("[]"));
    }

    public ScannerDelegate getIntegerScanner() {
        return skipWhitespace(new IntegerScanner());
    }

    public ScannerDelegate getKeywordAsScanner() {
        return skipWhitespace("as\\b");
    }

    public ScannerDelegate getKeywordFromScanner() {
        return skipWhitespace("from\\b");
    }

    public ScannerDelegate getKeywordIfScanner() {
        return skipWhitespace("if\\b");
    }

    public ScannerDelegate getKeywordImportScanner() {
        return skipWhitespace("import\\b");
    }

    public ScannerDelegate getKeywordJavaScanner() {
        return skipWhitespace("java\\b");
    }

    public ScannerDelegate getKeywordModuleScanner() {
        return skipWhitespace("module\\b");
    }

    public ScannerDelegate getKeywordNegativeScanner() {
        return skipWhitespace("negative\\b");
    }

    public ScannerDelegate getKeywordObjectScanner() {
        return skipWhitespace("object\\b");
    }

    public ScannerDelegate getKeywordPositiveScanner() {
        return skipWhitespace("positive\\b");
    }

    public ScannerDelegate getLessThanEqualsScanner() {
        return skipWhitespace(quote("<="));
    }

    public ScannerDelegate getLessThanScanner() {
        return skipWhitespace(quote("<"));
    }

    public ScannerDelegate getLogicalAndScanner() {
        return skipWhitespace("and\\b");
    }

    public ScannerDelegate getLogicalNotScanner() {
        return skipWhitespace("not\\b");
    }

    public ScannerDelegate getLogicalOrScanner() {
        return skipWhitespace("or\\b");
    }

    public ScannerDelegate getModuloScanner() {
        return skipWhitespace(quote("%"), "mod\\b");
    }

    public ScannerDelegate getMultiplyScanner() {
        return skipWhitespace(quote("*"));
    }

    public ScannerDelegate getNegativeScanner() {
        return skipWhitespace(quote("-"));
    }

    public ScannerDelegate getNotEqualsScanner() {
        return skipWhitespace(quote("<>"), "is\\s+not\\b");
    }

    public ScannerDelegate getNullScanner() {
        return skipWhitespace("Nothing\\b");
    }

    public ScannerDelegate getPositiveScanner() {
        return skipWhitespace(quote("+"));
    }

    public ScannerDelegate getSeparatorScanner() {
        return skipWhitespace(quote(","));
    }

    public ScannerDelegate getShiftLeftScanner() {
        return skipWhitespace(quote("<<"));
    }

    public ScannerDelegate getShiftRightScanner() {
        return skipWhitespace(quote(">>>"));
    }

    public ScannerDelegate getSignedShiftRightScanner() {
        return skipWhitespace(quote(">>"));
    }

    public ScannerDelegate getStringScanner() {
        return skipWhitespace(new StringScanner());
    }

    public ScannerDelegate getSubtractScanner() {
        return skipWhitespace(quote("-"));
    }

    public ScannerDelegate getTerminatorScanner() {
        return new TerminatorScanner();
    }

    public ScannerDelegate getTernaryFalseScanner() {
        return skipWhitespace("else\\b");
    }

    public ScannerDelegate getTernaryTrueScanner() {
        return skipWhitespace("then\\b");
    }

    public ScannerDelegate getWildcardScanner() {
        return skipWhitespace(quote("*"));
    }
}
