package org.sterling.source.scanner;

import static java.util.regex.Pattern.compile;
import static org.sterling.source.scanner.ScannerUtil.unexpectedInput;

import java.util.regex.Pattern;
import org.sterling.SterlingException;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class StaticTokenScanner implements ScannerDelegate {

    private final Pattern patterns;

    public StaticTokenScanner(String... values) {
        StringBuilder builder = new StringBuilder();
        builder.append("^(");
        builder.append(values[0]);
        for (int i = 1; i < values.length; i++) {
            builder.append('|');
            builder.append(values[i]);
        }
        builder.append(')');
        patterns = compile(builder.toString());
    }

    @Override
    public boolean expect(NodeKind kind, InputReader reader) {
        return reader.expect(patterns);
    }

    @Override
    public Token require(NodeKind kind, InputReader reader) throws SterlingException {
        if (reader.store(patterns)) {
            return reader.accept(kind);
        }
        throw unexpectedInput(reader, kind);
    }
}
